import React from "react";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import { Builder } from "./pages/Builder";
import { Form } from "./pages/Form";
import { FormList } from "./pages/FormList";
import { FormResponses } from "./pages/FormResponses";

export const App = () => {
  return (
    <>
      <BrowserRouter>
        <Routes>
          <Route path="/" element={<FormList />} />
          <Route path="/builder" element={<Builder />} />
          <Route path="/form/:id" element={<Form />} />
          <Route path="/form/:id/responses" element={<FormResponses />} />
        </Routes>
      </BrowserRouter>
    </>
  );
};
